/*
 * Decompiled with CFR 0.152.
 */
package notryken.effecttimerplus.gui.component.listwidget;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_5251;
import net.minecraft.class_5676;
import net.minecraft.class_6379;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import notryken.effecttimerplus.gui.component.widget.ArgbChannelSlider;
import notryken.effecttimerplus.gui.screen.ConfigScreen;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractListWidget
extends class_4265<Entry> {
    protected final ConfigScreen parent;

    public AbstractListWidget(class_310 minecraft, int width, int height, int top, int bottom, int itemHeight, ConfigScreen parent) {
        super(minecraft, width, height, top, bottom, itemHeight);
        this.parent = parent;
    }

    protected void reload() {
        this.parent.reload();
    }

    public int method_25322() {
        return this.field_22742 - 15;
    }

    protected static abstract class Entry
    extends class_4265.class_4266<Entry> {
        protected final AbstractListWidget list;
        protected final List<class_339> elements;

        public Entry(AbstractListWidget list) {
            this.list = list;
            this.elements = new ArrayList<class_339>();
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return this.elements;
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return this.elements;
        }

        public void method_25343(@NotNull class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.elements.forEach(element -> {
                element.method_46419(y);
                element.method_25394(graphics, mouseX, mouseY, tickDelta);
            });
        }

        protected static class ColorSelectionSet
        extends Entry {
            int[] colors = new int[]{0x990000, 0xFF0000, 16753920, 16761856, 0xFFFF00, 65280, 32768, 19456, 2142890, 65535, 255, 0x800080, 0xFF00FF, 0xFFFFFF, 0x808080, 0};

            public ColorSelectionSet(AbstractListWidget list, int x, int y, int width, Consumer<Integer> dest) {
                super(list);
                int buttonWidth = width / this.colors.length;
                for (int i = 0; i < this.colors.length; ++i) {
                    int color = this.colors[i];
                    int setX = x + width / 2 - buttonWidth * this.colors.length / 2;
                    this.elements.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2588").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)color))), button -> {
                        dest.accept(color);
                        for (Entry entry : list.method_25396()) {
                            if (!(entry instanceof ArgbSliderEntry2)) continue;
                            ArgbSliderEntry2 sliderEntry = (ArgbSliderEntry2)entry;
                            sliderEntry.refresh();
                        }
                    }).method_46433(setX + buttonWidth * i, y).method_46437(buttonWidth, buttonWidth).method_46431());
                }
            }
        }

        protected static class ArgbSliderEntry2
        extends Entry {
            ArgbChannelSlider slider;

            public ArgbSliderEntry2(AbstractListWidget list, int x, int width, int height, @Nullable String message, Supplier<Integer> source, Consumer<Integer> dest, IntUnaryOperator toChannel, IntUnaryOperator fromChannel) {
                super(list);
                this.slider = new ArgbChannelSlider(x, 0, width, height, message, null, source, dest, toChannel, fromChannel);
                this.elements.add(this.slider);
            }

            public void refresh() {
                this.slider.refresh();
            }
        }

        protected static class IntCycleButtonEntry
        extends Entry {
            public IntCycleButtonEntry(AbstractListWidget list, int x, int y, int width, int height, class_2561 label, int initial, Function<Integer, class_2561> intToText, Integer[] values, Consumer<Integer> dest) {
                super(list);
                class_5676 cycleButton = class_5676.method_32606(intToText).method_32619((Object)initial).method_32624((Object[])values).method_32617(x, y, width, height, label, (button, value) -> dest.accept((Integer)value));
                this.elements.add(cycleButton);
            }
        }

        protected static class DualOnOffButtonEntry
        extends Entry {
            public DualOnOffButtonEntry(AbstractListWidget list, int x, int y, int width, int height, class_2561 leftLabel, boolean leftInitial, Consumer<Boolean> leftDest, class_2561 rightLabel, boolean rightInitial, Consumer<Boolean> rightDest) {
                super(list);
                class_5676 leftCycleButton = class_5676.method_32613((boolean)leftInitial).method_32617(x, y, width / 2 - 2, height, leftLabel, (button, status) -> leftDest.accept((Boolean)status));
                class_5676 rightCycleButton = class_5676.method_32613((boolean)rightInitial).method_32617(x + width / 2 + 2, y, width / 2 - 2, height, rightLabel, (button, status) -> rightDest.accept((Boolean)status));
                this.elements.add(leftCycleButton);
                this.elements.add(rightCycleButton);
            }
        }

        protected static class OnOffButtonEntry
        extends Entry {
            public OnOffButtonEntry(AbstractListWidget list, int x, int y, int width, int height, class_2561 label, boolean initial, Consumer<Boolean> dest) {
                super(list);
                class_5676 cycleButton = class_5676.method_32613((boolean)initial).method_32617(x, y, width, height, label, (button, status) -> dest.accept((Boolean)status));
                this.elements.add(cycleButton);
            }
        }

        protected static class ActionButtonEntry
        extends Entry {
            public ActionButtonEntry(AbstractListWidget list, int x, int y, int width, int height, class_2561 label, class_4185.class_4241 onPress) {
                super(list);
                class_4185 actionButton = class_4185.method_46430((class_2561)label, (class_4185.class_4241)onPress).method_46433(x, y).method_46437(width, height).method_46431();
                this.elements.add(actionButton);
            }
        }

        protected static class TextEntry
        extends Entry {
            public TextEntry(AbstractListWidget list, int x, int y, int width, int height, class_2561 message, class_7919 ... tooltip) {
                super(list);
                class_7842 textEntry = new class_7842(x, y, width, height, message, class_310.method_1551().field_1772);
                if (tooltip.length == 1) {
                    textEntry.method_47400(tooltip[0]);
                }
                this.elements.add(textEntry);
            }
        }
    }
}

